capture log close
clear all
macro drop _all
set more off
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Input substitution\Stata\1. NZ Data"
log using log/NZasset5, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function Development Program
Author:  Alice Giovani
File:    NZasset5.do
Initial Date:    23-Oct-2022
Revised Date:	 01-May-2025

Purpose: Merge the datasets

--------------------------------------------------------------------------*/

*tempfile maindat rabratio

use dta/nzasset1, clear
describe

merge 1:1 eiid year using dta/nzasset2, update
drop _merge
sort eiid year
describe

merge 1:1 eiid year using dta/nzasset3, update
drop _merge
sort eiid year
describe

merge 1:1 eiid year using dta/nzasset4, update
drop _merge
sort eiid year
describe

rename depr sl_depr

drop if year == 2005
gen country = 2

replace NVWACC = 0.0782   if year == 2011 & NVWACC == . // from 2013-2018 disclosure workbook

****Vector and Wellington Adjustment - See Adj workbook

replace orab = 1632490.553231 if eiid == 2001 & year == 2006
replace orab = 1737697.16905699 if eiid == 2001 & year == 2007
replace orab = 1808449.20792315 if eiid == 2001 & year == 2008
replace orab = 1967173.20259561 if eiid == 2001 & year == 2009

replace crab = 1721922.10437571 if eiid == 2001 & year == 2006
replace crab = 1792031.84606298 if eiid == 2001 & year == 2007
replace crab = 1949314.92149645 if eiid == 2001 & year == 2008
replace crab = 2048978.66827687 if eiid == 2001 & year == 2009

replace sl_depr = 114981.23074589 if eiid == 2001 & year == 2006
replace sl_depr = 103029.70111349 if eiid == 2001 & year == 2007
replace sl_depr = 132711.11240725 if eiid == 2001 & year == 2008
replace sl_depr = 130047.33362253 if eiid == 2001 & year == 2009

replace infl = 53594.99535612 if eiid == 2001 & year == 2006
replace infl = 43283.04803491 if eiid == 2001 & year == 2007
replace infl = 60086.62306607 if eiid == 2001 & year == 2008
replace infl = 57614.75148345 if eiid == 2001 & year == 2009

replace tax = 42227.40843969 if eiid == 2001 & year == 2008
replace tax = 46763.50929707 if eiid == 2001 & year == 2009
*-
replace orab = 360636.446769 if eiid == 2019 & year == 2006
replace orab = 383877.83094301 if eiid == 2019 & year == 2007
replace orab = 399507.79207685 if eiid == 2019 & year == 2008
replace orab = 434571.79740439 if eiid == 2019 & year == 2009

replace crab = 399652.89562429 if eiid == 2019 & year == 2006
replace crab = 415925.15393702 if eiid == 2019 & year == 2007
replace crab = 452430.07850355 if eiid == 2019 & year == 2008
replace crab = 475561.73172314 if eiid == 2019 & year == 2009

replace sl_depr = 26318.86925411 if eiid == 2019 & year == 2006
replace sl_depr = 23583.19888651 if eiid == 2019 & year == 2007
replace sl_depr = 30377.18759275 if eiid == 2019 & year == 2008
replace sl_depr = 29767.45637747 if eiid == 2019 & year == 2009

replace infl = 12341.11464388 if eiid == 2019 & year == 2006
replace infl = 9966.62196509 if eiid == 2019 & year == 2007
replace infl = 13835.91693393 if eiid == 2019 & year == 2008
replace infl = 13266.72851655 if eiid == 2019 & year == 2009

replace tax = 5975.04956031 if eiid == 2019 & year == 2008
replace tax = 6616.89400293 if eiid == 2019 & year == 2009

*Risk Free Rate - See Consolidate Workbook
gen RFR =.
replace RFR = 0.0581 if year == 2006
replace RFR = 0.0638 if year == 2007
replace RFR = 0.0609 if year == 2008
replace RFR = 0.0569 if year == 2009
replace RFR = 0.0561 if year == 2010
replace RFR = 0.0495 if year == 2011
replace RFR = 0.0365 if year == 2012
replace RFR = 0.0411 if year == 2013
replace RFR = 0.0431 if year == 2014
replace RFR = 0.0343 if year == 2015
replace RFR = 0.0278 if year == 2016
replace RFR = 0.0299 if year == 2017
replace RFR = 0.0275 if year == 2018
replace RFR = 0.0166 if year == 2019
replace RFR = 0.0089 if year == 2020
replace RFR = 0.0183 if year == 2021
replace RFR = 0.0364 if year == 2022
replace RFR = 0.0463 if year == 2023

*Cost of Debt - From 2008-2012 Disclosure workbook 
replace CostDebt = 0.0811 if year == 2008 & eiid == 2009 & eiid == 2003
replace CostDebt = 0.0888 if year == 2008 & eiid == 2017
replace CostDebt = 0.08 if year == 2008 & CostDebt == .

replace CostDebt = 0.081 if year == 2009 & eiid == 2017
replace CostDebt = 0.08 if year == 2009 & eiid == 2013
replace CostDebt = 0.0829 if year == 2009 & eiid == 2003
replace CostDebt = 0.0818 if year == 2009 & CostDebt == .

replace CostDebt = 0.0552 if year == 2010 & CostDebt == .
replace CostDebt = 0.0659 if year == 2011 & CostDebt == .
replace CostDebt = 0.0582 if year == 2012 & CostDebt == .

*Creating Debt Margin 
gen DM = CostDebt - RFR

*Creating Other Parameters
gen roc = NVWACC * orab
gen RTA_roc = tax/roc
gen BTLrate = tax/orab
gen infrate = infl/orab

gen deprate = sl_depr/orab


gen auc = roc + depr - infl + tax
order country eiid year 

export excel using xlsx/nzasset5.xlsx, firstrow(var) sheet("step1", modify)
save dta/nzasset5, replace

log close
exit
